<?php
$this->show('codeshare/codeshare_header.php');
?>
<h3>Flights operated by <?php echo $codeshare->name; ?></h3>
<?php
if(count($schedules) == 0) {
  ?>
    <div class="alert alert-danger">
      <strong>
        Hey!
      </strong>
      There are no codeshare flights with this operator. Go to the <a href="<?php echo adminurl('/CodeShare_admin/addcodeshare'); ?>"> wizard </a> now!
    </div>
  <?php
} else {
?>
<div class="table">
  <table class="table table-responsive table-hover">
    <thead>
      <th>#</th>
      <th>Callsign</th>
      <th>Schedule ID</th>
      <th>Flight</th>
      <th>Operator</th>
      <th>Options</th>
    </thead>
    <tbody>
<?php
  $i = 1;
  foreach ($schedules as $schedule) {
    $details = SchedulesData::getSchedule($schedule->schedid);
    ?>
      <tr>
        <td><?php echo $i; ?></td>
        <td><?php echo $details->code.$details->flightnum; ?></td>
        <td><?php echo $schedule->schedid; ?></td>
        <td><a href="<?php echo adminurl('codeshare_admin/viewairline'); ?>/<?php echo $schedule->icao; ?>" class="btn btn-primary"><?php echo $details->depicao; ?> - <?php echo $details->arricao; ?></a></td>
        <td><?php echo $schedule->operator; ?></td>
        <td><a href="javascript::void(0);" class="btn btn-xs btn-success">Edit</a></td>
      </tr>
    <?php
    $i++;
  }
}
?>
    </tbody>
  </table>
</div>
